import pandas as pd   
from sklearn.preprocessing import LabelEncoder
import pickle
from decision_company import read_csv_file, avg, bind_dataframe

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Analyze the relationship between employment status and loan duration   
employment_duration_relationship = avg(bind_dataframe(stable_employment, 'employment')['duration']) 
   
# Print the relationship   
print("\nRelationship between employment status and loan duration:\n", employment_duration_relationship)   
pickle.dump(employment_duration_relationship, open("./ref_result/employment_duration_relationship.pkl","wb"))

  